<?php
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');

$hardware_codes = ['3776', '3952', '3984', '8485', '8484', '8590', '8603'];
$api_url = "https://tatonas.co.id/api/v2/realtime?uc=QSAygEUI_dinas_puprpkpp_provinsi_riau&pc=059&hw=";
//$response = @file_get_contents($api_url);
foreach($hardware_codes as $alat){
    $response = @file_get_contents($api_url.$alat);
    if ($response === FALSE) {
        http_response_code(500);
        echo json_encode(['error' => 'Gagal mengambil data dari API.']);
        exit;
    }

    $data = json_decode($response);

    if (empty($data) || !isset($data->data)) {
        http_response_code(500);
        echo json_encode(['error' => 'Data dari API tidak valid atau kosong.']);
        exit;
    }

    $sensor_data = $data->data;

    $curah_hujan = $sensor_data->sensor->{"Curah Hujan"} ?? null;
    $tinggi_muka_air_data = $sensor_data->sensor->{"Tinggi Muka Air"} ?? null;

    if ($tinggi_muka_air_data) {
        $value_actual = $tinggi_muka_air_data->value_actual ?? 'N/A';
        $unit = $tinggi_muka_air_data->unit ?? 'N/A';
        $alarm_level = $tinggi_muka_air_data->alarm_level ?? 'N/A';
    } else if ($curah_hujan){
        $value_actual = $curah_hujan->value_actual ?? 'N/A';
        $unit = $curah_hujan->unit ?? 'N/A';
        $alarm_level = $curah_hujan->alarm_level ?? 'N/A';
    }else {
        // Jika data tidak ditemukan, tetapkan nilai default 'N/A'
        $value_actual = 'N/A';
        $unit = 'N/A';
        $alarm_level = 'N/A';
    }
    // Format ulang data agar lebih mudah digunakan
    $formatted_data = [
        'alat'          => $alat ?? 'N/A',
        'location'      => $sensor_data->location ?? 'N/A',
        'desa'          => $sensor_data->desa ?? 'N/A',
        'kecamatan'     => $sensor_data->kecamatan ?? 'N/A',
        'kabupaten'     => $sensor_data->kabupaten ?? 'N/A',
        'provinsi'      => $sensor_data->provinsi ?? 'N/A',
        'latitude'      => $sensor_data->latitude ?? 'N/A',
        'longitude'     => $sensor_data->longitude ?? 'N/A',
        'last_sending'  => $sensor_data->last_sending ?? 'N/A',
        'value_actual'  => $value_actual,
        'unit'          => $unit,
        'alarm_level'   => $alarm_level
    ];

    //echo json_encode($formatted_data);
    $datas [] =  $formatted_data;
}
//
echo $jsonString = json_encode($datas);
// echo "<pre>";
//     print_r($jsonString);
// echo "</pre>"

?>