<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Landing Page Dua Kolom dengan Card</title>

    <!-- External Resources -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" xintegrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    

    <style>
        /* ===== VARIABLES ===== */
        :root {
            --primary-color: #343a40;
            --secondary-color: #6c757d;
            --accent-color: #0d6efd;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --overlay-opacity: 0.85;
            --btn-hover-shadow: 0 8px 15px rgba(0, 0, 0, 0.2);
            --transition-speed: 0.3s;
            --card-border-radius: 15px;
        }

        /* ===== BASE STYLES ===== */
        body,
        html {
            height: 100%;
            margin: 0;
            font-family: 'Poppins', sans-serif;
            overflow: hidden;
        }

        /* ===== LAYOUT CONTAINER ===== */
        .main-container {
            display: flex;
            height: 100vh;
            width: 100%;
        }

        /* ===== LEFT COLUMN ===== */
        .left-column {
            width: 25%;
            background: linear-gradient(135deg, #343a40 0%, #2c3136 100%);
            padding: 20px;
            overflow-y: auto;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            z-index: 2;
        }

        /* ===== RIGHT COLUMN ===== */
        .right-column {
            width: 75%;
            margin-left: 25%;
            position: relative;
            height: 100vh;
        }

        /* Background Slider */
        .right-bg-slider {
            height: 100%;
            position: relative;
        }

        .carousel-item-bg {
            height: 100%;
            background-size: cover;
            background-position: center;
        }

        .carousel-item-video {
            height: 100%;
            position: relative;
            overflow: hidden;
        }

        .carousel-item-video video {
            min-width: 100%;
            min-height: 100%;
            width: auto;
            height: auto;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            object-fit: cover;
        }

        /* Slider Overlay */
        .slider-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            /* PERBAIKAN SEBELUMNYA: Mengurangi opacity menjadi 0.2 untuk kontras yang lebih cerah */
            background-color: rgba(0, 0, 0, 0.2); 
            z-index: 1;
        }

        /* ===== CARD STYLES (Left Column) ===== */
        .card-left {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border-radius: var(--card-border-radius);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            margin-bottom: 20px;
            color: white;
        }

        .card-left:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
            background: rgba(255, 255, 255, 0.15);
        }

        .card-icon {
            font-size: 1.8rem;
            margin-bottom: 15px;
            color: var(--accent-color);
        }

        .card-title {
            font-weight: 700;
            margin-bottom: 10px;
            font-size: 1.2rem;
        }

        .card-text {
            font-size: 0.9rem;
            opacity: 0.9;
        }

        /* Left Content Container */
        .left-content {
            padding: 10px 5px;
        }

        .section-title {
            color: white;
            font-weight: 100;
            margin-bottom: 5px;
            text-align: center;
            position: relative;
            padding-bottom: 5px;
        }

        .section-title:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 50px;
            height: 3px;
            background: var(--accent-color);
        }

        /* ===== MAIN CONTENT (Right Column Overlay) ===== */
        .main-content {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 2;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        
        /* Custom Styling for the Sambutan Card */
        .sambutan-card {
            max-width: 800px;
            width: 90%;
            border-radius: 1.5rem; /* rounded-4 equivalent */
            border: 3px solid #198754; /* Green border (success) */
            box-shadow: 0 1rem 3rem rgba(0, 0, 0, 0.5);
        }

        /* Center content in right column */
        .center-content {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100%;
            text-align: center;
            padding: 0 15px;
            color: white; /* Default text color for centered content */
        }

        /* Carousel Controls */
        .carousel-control-prev,
        .carousel-control-next {
            z-index: 3;
        }

        /* Custom Navbar */
        .navbar-custom {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            z-index: 10;
            padding: 15px 0;
        }

        .navbar-nav {
            background: rgba(0, 0, 0, 0.1);
            border-radius: 50px;
            padding: 5px 15px;
            backdrop-filter: blur(10px);
        }

        /* Custom Button */
        .btn-custom {
            font-weight: 600;
            border-radius: 50px;
            padding: 12px 30px;
            transition: transform var(--transition-speed) ease,
                box-shadow var(--transition-speed) ease;
        }

        .btn-custom:hover {
            transform: translateY(-3px);
            box-shadow: var(--btn-hover-shadow);
        }

        /* ===== RESPONSIVE ADJUSTMENTS ===== */
        @media (max-width: 991.98px) {
            .left-column {
                width: 35%;
            }

            .right-column {
                width: 65%;
                margin-left: 35%;
            }
        }

        @media (max-width: 767.98px) {
            .display-3 {
                font-size: 2.5rem;
            }

            .btn-custom {
                padding: 10px 20px;
            }

            .left-column {
                width: 100%;
                position: relative;
                height: auto;
                min-height: 50vh;
            }

            .right-column {
                width: 100%;
                margin-left: 0;
                height: 100vh;
            }

            .main-container {
                flex-direction: column;
            }

            .card-left {
                margin-bottom: 15px;
            }

            .navbar-nav {
                background: rgba(0, 0, 0, 0);
            }
        }

        /* Custom Scrollbar */
        .left-column::-webkit-scrollbar {
            width: 6px;
        }

        .left-column::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
        }

        .left-column::-webkit-scrollbar-thumb {
            background: var(--accent-color);
            border-radius: 10px;
        }
        
        /* ========================================
        CUSTOM STYLES FOR SENSOR DATA CARD LIST
        ======================================== 
        */
        .sensor-item {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            padding: 10px;
            margin-bottom: 2px;
            display: flex;
            flex-direction: column;
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.2s ease;
            cursor: pointer;
        }

        .sensor-item:hover {
            background: rgba(255, 255, 255, 0.15);
            box-shadow: 0 0 10px rgba(13, 110, 253, 0.5); /* Soft blue shadow on hover */
        }

        .sensor-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 5px;
        }

        .sensor-title {
            font-size: 1rem;
            font-weight: 600;
            color: white;
            margin: 0;
        }

        .sensor-icon {
            color: #198754; /* Green check icon */
            font-size: 1.1rem;
            margin-right: 5px;
        }
        
        .sensor-badge {
            background-color: var(--accent-color);
            color: white;
            padding: 2px 8px;
            border-radius: 4px;
            font-size: 0.75rem;
            font-weight: 700;
            margin-right: 8px;
        }

        .sensor-badge.awl {
            background-color: #0d6efd; /* Blue */
        }
        
        .sensor-badge.arl {
            background-color: #3ddc35ff; /* Red/Alert */
        }

        .sensor-info {
            display: flex;
            align-items: center;
            font-size: 0.75rem;
            opacity: 0.8;
            color: var(--light-color);
        }

        .sensor-info i {
            margin-right: 3px;
        }

        .sensor-value-container {
            display: flex;
            align-items: center;
            margin-top: 5px;
        }

        .sensor-value {
            background-color: var(--accent-color);
            color: white;
            padding: 10px 15px;
            border-radius: 6px;
            font-size: 1rem;
            font-weight: 700;
            text-align: center;
            min-width: 80px;
            margin-left: 10px;
        }

        .sensor-value.alert-red {
            background-color: #dc3545; /* Red */
        }

        .sensor-value.alert-yellow {
            background-color: #ffc107; /* Yellow */
        }

        .sensor-value.normal-blue {
            background-color: #0d6efd; /* Blue */
        }
        
        .sensor-value.normal-green {
            background-color: #198754; /* Green */
        }

        /* Custom Progress Bar/Level Indicator */
        .level-indicator {
            flex-grow: 1;
        }

        .level-indicator-bar {
            height: 10px;
            background-color: rgba(255, 255, 255, 0.3);
            border-radius: 5px;
            overflow: hidden;
            margin-bottom: 3px;
            position: relative;
        }
        
        /* Bar Segments (Simulating colored zones) */
        .level-indicator-segments {
            display: flex;
            height: 100%;
        }

        .level-segment {
            height: 100%;
        }

        .segment-green { background-color: #198754; }
        .segment-yellow { background-color: #ffc107; }
        .segment-red { background-color: #dc3545; }
        .segment-orange { background-color: rgba(220, 139, 53, 1); }

        /* Current value indicator (the thin line) */
        .current-level-mark {
            position: absolute;
            top: 0;
            width: 3px; /* Thickness of the marker */
            height: 100%;
            background-color: white; /* White marker */
            box-shadow: 0 0 5px rgba(0,0,0,0.5);
            /* This 'left' property will be dynamically set by JS later
               For now, we place it for visual reference: */
            left: 50%; 
            transform: translateX(-50%);
            z-index: 5;
        }
        
        /* Progress Bar Ticks/Labels (Simulating values below the bar) */
        .level-labels {
            display: flex;
            justify-content: space-between;
            font-size: 0.65rem;
            color: var(--light-color);
            opacity: 0.8;
            position: relative;
            margin-top: 5px;
        }
    </style>
</head>

<body>
    <div class="main-container">
        <!-- Left Column with Cards -->
        <div class="left-column">
            <div class="left-content">
                <h2 class="section-title"><i class="card-icon bi bi-bar-chart"></i> Data SENSOR</h2>

                <div id="dataContent">
                    <!-- 
                        CONTOH-CONTOH DATA SENSOR BARU (DIBUAT MIRIP DENGAN GAMBAR) 
                        
                        Catatan: Saya menggunakan nilai CSS 'width' inline untuk simulasi 
                        progres bar karena data aslinya berasal dari sumber eksternal.
                        Level Bar: Green -> Yellow -> Red
                    -->

                    <!-- SENSOR ITEM 1: ARL - Red Alert (Level Max) -->
                    <div class="sensor-item">
                        <div class="sensor-header">
                            <h5 class="sensor-title"><i class="sensor-icon bi bi-geo-alt-fill"></i> Sungai Beran</h5>
                            <div class="d-flex align-items-center">
                                <span class="sensor-badge arl">ARL | 3776</span>
                            </div>
                        </div>
                        <p class="sensor-info m-0">
                            <i class="bi bi-calendar"></i> 2025-10-01 12:00:00
                        </p>
                        <div class="sensor-value-container">
                            <div class="level-indicator">
                                <div class="level-indicator-bar">
                                    <div class="level-indicator-segments">
                                        <div class="level-segment segment-green" style="width: 50%;"></div>
                                        <div class="level-segment segment-yellow" style="width: 30%;"></div>
                                        <div class="level-segment segment-red" style="width: 20%;"></div>
                                    </div>
                                    <!-- Marker ditempatkan pada posisi 100% -->
                                    <div class="current-level-mark" style="left: 95%;"></div> 
                                </div>
                                <div class="level-labels">
                                    <span>0</span>
                                    <span>50</span>
                                    <span>100</span>
                                    <span>mm</span>
                                </div>
                            </div>
                            <!-- Nilai yang ditampilkan -->
                            <div class="sensor-value alert-red">0 mm</div> 
                        </div>
                    </div>
                    
                    <!-- SENSOR ITEM 2: AWL - Red Alert (Level Tinggi) -->
                    <div class="sensor-item">
                        <div class="sensor-header">
                            <h5 class="sensor-title"><i class="sensor-icon bi bi-geo-alt-fill"></i> Sungai Beran</h5>
                            <div class="d-flex align-items-center">
                                <span class="sensor-badge awl">AWL | 8484</span>
                            </div>
                        </div>
                        <p class="sensor-info m-0">
                            <i class="bi bi-calendar"></i> 2025-10-01 12:30:00
                        </p>
                        <div class="sensor-value-container">
                            <div class="level-indicator">
                                <div class="level-indicator-bar">
                                    <div class="level-indicator-segments">
                                        <div class="level-segment segment-green" style="width: 40%;"></div>
                                        <div class="level-segment segment-yellow" style="width: 30%;"></div>
                                        <div class="level-segment segment-red" style="width: 30%;"></div>
                                    </div>
                                    <!-- Marker ditempatkan pada posisi 80% (misalnya 411 cm dari 500 cm max) -->
                                    <div class="current-level-mark" style="left: 80%;"></div> 
                                </div>
                                <div class="level-labels">
                                    <span>2</span>
                                    <span>175</span>
                                    <span>200</span>
                                    <span>cm</span>
                                </div>
                            </div>
                            <div class="sensor-value alert-red">411 cm</div>
                        </div>
                    </div>
                    
                    <!-- SENSOR ITEM 3: AWL - Normal/Yellow Alert (Level Sedang) -->
                    <div class="sensor-item">
                        <div class="sensor-header">
                            <h5 class="sensor-title"><i class="sensor-icon bi bi-geo-alt-fill"></i> Sungai Liong</h5>
                            <div class="d-flex align-items-center">
                                <span class="sensor-badge awl">AWL | 8485</span>
                            </div>
                        </div>
                        <p class="sensor-info m-0">
                            <i class="bi bi-calendar"></i> 2025-10-01 12:00:00
                        </p>
                        <div class="sensor-value-container">
                            <div class="level-indicator">
                                <div class="level-indicator-bar">
                                    <div class="level-indicator-segments">
                                        <div class="level-segment segment-green" style="width: 70%;"></div>
                                        <div class="level-segment segment-yellow" style="width: 20%;"></div>
                                        <div class="level-segment segment-red" style="width: 10%;"></div>
                                    </div>
                                    <!-- Marker ditempatkan pada posisi 50% -->
                                    <div class="current-level-mark" style="left: 50%;"></div> 
                                </div>
                                <div class="level-labels">
                                    <span>50</span>
                                    <span>200</span>
                                    <span>250</span>
                                    <span>cm</span>
                                </div>
                            </div>
                            <div class="sensor-value alert-yellow">126 cm</div>
                        </div>
                    </div>


                </div>
                <!--card statis dihapus dan diganti dengan contoh di atas-->
                <!-- <div class="card h-100 mt-2">
                    <div class="card-body">
                        <h5 class="card-title">Title</h5>
                        <h6 class="card-subtitle mb-2 text-muted">Alat: </h6>
                        <p class="card-text">
                            <strong>Nilai:</strong>  <br>
                            <strong>Lokasi:</strong>  <br>
                            <strong>Kabupaten:</strong> <br>
                            <strong>Provinsi:</strong>  <br>
                            <small class="text-muted">Terakhir Kirim: </small>
                        </p>
                    </div>
                </div> -->
                </div>
        </div>

        <!-- Right Column with Background -->
        <div class="right-column">
            <div class="right-bg-slider">
                <div id="heroCarousel" class="carousel slide carousel-fade h-100" data-bs-ride="carousel" data-bs-interval="10000">
                    <div class="carousel-inner h-100">
                        
                        <!-- 1. SLIDE KATA SAMBUTAN (DIJADIKAN AKTIF) -->
                        <div class="carousel-item active h-100">
                            <div class="container h-100 d-flex align-items-center justify-content-center py-5">
                                <div class="card sambutan-card bg-white p-4 p-md-5 text-dark">
                                    
                                    <!-- Header/Judul -->
                                    <div class="text-center mb-4 mb-md-5">
                                        <p class="h5 fw-light text-secondary mb-1">
                                            Selamat Datang Di Website Resmi
                                        </p>
                                        <hr>
                                        <h2 class="h3 h2-md fw-bolder text-success leading-tight">
                                            Dinas Pekerjaan Umum, Penataan Ruang, Perumahan, Kawasan Permukiman dan Pertanahan Provinsi Riau
                                        </h2>
                                    </div>

                                    <div class="row">
                                        <!-- FOTO PEJABAT (KOLOM KIRI) -->
                                        <div class="col-12 col-md-4 d-flex flex-column align-items-center mb-4 mb-md-0">
                                            <div class="p-2 border border-success border-4 rounded-3 shadow-lg">
                                                <!-- Placeholder Image - Silakan ganti URL ini dengan foto asli Kepala Dinas -->
                                                <img 
                                                    src="src/pic/kabid.jpg" 
                                                    alt="Kepala Bidang SDA"
                                                    class="img-fluid rounded"
                                                    onerror="this.onerror=null;this.src='https://placehold.co/400x480/4ade80/ffffff?text=FOTO+KADIS';" 
                                                >
                                            </div>
                                            <div class="mt-3 text-center">
                                                <p class="small text-muted mb-0">Kepala Bidang Sumber Daya Air</p>
                                            </div>
                                        </div>

                                        <!-- ISI SAMBUTAN (KOLOM KANAN) -->
                                        <div class="col-12 col-md-8 text-base text-secondary">
                                            
                                            <p class="text-center fw-bolder fs-5 text-dark pt-2">
                                                ASSALAMUALAIKUM, WR, WB
                                            </p>

                                            <p class="text-justify lh-base">
                                                Dengan bangga kami persembahkan website resmi Bidang Sumber Daya Air (SDA) pada Dinas Pekerjaan Umum, Penataan Ruang, Perumahan, Kawasan Permukiman dan Pertanahan Provinsi Riau, yaitu sda.pupr.riau.go.id.
                                            </p>

                                            <p class="text-justify lh-base">
                                                Kehadiran website ini merupakan wujud komitmen kami untuk mewujudkan transparansi, akuntabilitas, dan pelayanan publik yang lebih baik. Sumber Daya Air adalah sektor vital yang menjadi penopang kehidupan dan pembangunan di Provinsi Riau. Melalui platform digital ini, kami berupaya menyajikan informasi terkini dan terlengkap mengenai program kerja, kegiatan, data strategis, serta berbagai regulasi terkait pengelolaan sumber daya air, irigasi, dan pengendalian banjir di Bumi Lancang Kuning.
                                            </p>

                                            <p class="text-justify lh-base">
                                                Selamat menjelajah, dan terima kasih atas perhatian serta partisipasi Anda.

                                            </p>

                                            <!-- Penutup dan Tanda Tangan (Right-aligned untuk kesan formal) -->
                                            <div class="pt-4 text-end">
                                                <p class="mb-1 fw-medium text-dark">Wassalam</p>
                                                <p class="fw-bold fs-5 text-dark mb-0">H. YUFENDRI, ST</p>
                                                <p class="small text-muted mt-0">Kepala Bidang SDA DINAS PUPR-PKPP Provinsi Riau</p>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <!-- 2. SLIDE VIDEO (PENTING: MENGHAPUS ATRIBUT AUTOPLAY) -->
                        <div class="carousel-item carousel-item-video">
                            <!-- ATTRIBUTE AUTOPLAY DIHAPUS, KONTROL PENUH DENGAN JAVASCRIPT -->
                            <video muted loop>
                                <source src="src/vid/vd2.mp4" type="video/mp4">
                                Video tidak didukung.
                            </video>
                        </div>
                        <div class="carousel-item">SDAD</div>
                        <div class="carousel-item carousel-item-bg" style="background-image: url('https://images.unsplash.com/photo-1506744038136-46273834b3fb?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1770&q=80');"></div>
                        <div class="carousel-item carousel-item-bg" style="background-image: url('https://images.unsplash.com/photo-1510784722466-f2aa9c52fff6?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1770&q=80');"></div>
                    </div>

                    <button class="carousel-control-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Sebelumnya</span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Berikutnya</span>
                    </button>
                </div>
                <div class="slider-overlay"></div>
            </div>

            <!-- Main Content Overlay -->
            <div class="main-content">
                <!-- Navigation -->
                <nav class="navbar navbar-expand-lg navbar-dark navbar-custom">
                    <div class="container-fluid justify-content-center">
                        <ul class="navbar-nav mx-auto mb-2 mb-lg-0">
                            <li class="nav-item mx-2">
                                <a class="nav-link active" href="#">Beranda</a>
                            </li>
                            <li class="nav-item mx-2">
                                <a class="nav-link" href="#">Layanan</a>
                            </li>
                            <li class="nav-item mx-2">
                                <a class="navbar-brand" href="#">
                                    <img src="img/logosda.jpg" alt="Logo" style="invert(1); height: 40px;" class="img-fluid rounded-circle">
                                </a>
                            </li>
                            <li class="nav-item mx-2">
                                <a class="nav-link" href="#">Tentang</a>
                            </li>
                            <li class="nav-item mx-2">
                                <a class="nav-link" href="#">Kontak</a>
                            </li>
                        </ul>
                    </div>
                </nav>

                <!-- Center Content -->
                  <!--
                  <div class="center-content">
                      <h1 class="display-3 fw-bold mb-3">Selamat Datang</h1>
                      <p class="lead mb-4 w-75">
                          Nikmati pengalaman visual yang tak terlupakan dengan layanan profesional kami.
                      </p>
                      <div class="mt-4">
                          <a href="#" class="btn btn-primary btn-lg btn-custom me-3 mb-2">Mulai Sekarang</a>
                          <a href="#" class="btn btn-outline-light btn-lg btn-custom mb-2">Pelajari Lebih Lanjut</a>
                      </div>
                  </div>
                  -->
                <!-- Center Content -->
            </div>
        </div>
    </div>

    <!-- Scripts -->
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" xintegrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    <script src="js/data.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const myCarousel = document.getElementById('heroCarousel');
            const videos = myCarousel.querySelectorAll('video');

            // Handle video playback on carousel slide
            myCarousel.addEventListener('slid.bs.carousel', function() {
                // 1. Temukan slide yang baru aktif dan video di dalamnya
                const activeItem = myCarousel.querySelector('.carousel-item.active');
                const activeVideo = activeItem ? activeItem.querySelector('video') : null;

                // 2. Jeda SEMUA video yang TIDAK berada di slide yang baru aktif
                videos.forEach(video => {
                    // Hanya jeda jika video BUKAN video yang baru diaktifkan
                    if (video !== activeVideo) {
                        video.pause();
                        video.currentTime = 0; // Reset waktu
                    }
                });

                // 3. Putar video yang baru aktif (jika ada)
                if (activeVideo) {
                    activeVideo.play().catch(error => {
                        // Tangani jika pemutaran gagal (misalnya, browser masih mencegah pemutaran)
                        console.error("Gagal memutar video secara otomatis:", error);
                    });
                }
            });
            
            // Catatan: Karena slide pertama (sambutan) bukan video, 
            // kita tidak perlu memanggil .play() pada saat load.
        });
    </script>
</body>

</html>
