<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Landing Page Dua Kolom Background</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">

    <style>
        body, html {
            height: 100%;
            margin: 0;
            font-family: 'Poppins', sans-serif;
            overflow: hidden;
        }

        /* --- BACKGROUND CONTAINER (DUA KOLOM) --- */
        .background-layout {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -2;
        }

        /* Latar Belakang Kolom Kiri */
        .left-bg {
            background-color: #343a40;
            background-image: url('https://picsum.photos/400/800?random=3');
            background-size: cover;
            background-position: center;
            height: 100%;
            opacity: 0.85;
        }

        /* Latar Belakang Kolom Kanan */
        .right-bg-slider {
            height: 100%;
            position: relative;
        }
        
        .carousel-item-bg {
            height: 100%;
            background-size: cover;
            background-position: center;
        }

        .carousel-item-video {
            height: 100%;
            position: relative;
            overflow: hidden;
        }
        
        .carousel-item-video video {
            min-width: 100%;
            min-height: 100%;
            width: auto;
            height: auto;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        /* --- OVERLAY UNTUK SLIDER --- */
        .slider-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1;
        }

        /* --- KONTEN UTAMA (DIATAS BACKGROUND) --- */
        .main-content {
            position: relative;
            z-index: 1;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        /* Atur z-index tombol agar terlihat */
        .carousel-control-prev,
        .carousel-control-next {
            z-index: 3;
        }
        
        /* Navbar Custom */
        .navbar-custom {
            flex-grow: 0;
        }
        
        .btn-custom {
            font-weight: 600;
            border-radius: 50px;
            padding: 12px 30px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .btn-custom:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 15px rgba(0, 0, 0, 0.2);
        }

        /* Penyesuaian untuk konten di kolom kanan */
        .right-content {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100%;
        }
    </style>
</head>
<body>

    <div class="background-layout d-flex">
        <div class="left-bg col-md-3 d-none d-md-block"></div>

        <div class="col-md-9 d-none d-md-block right-bg-slider">
            <div id="heroCarousel" class="carousel slide carousel-fade h-100" data-bs-ride="carousel" data-bs-interval="5000">
                <div class="carousel-inner h-100">
                    <div class="carousel-item carousel-item-video active">
                        <video autoplay muted>
                            <source src="src/vid/vd2.mp4" type="video/mp4">
                            Video tidak didukung.
                        </video>
                    </div>
                    <div class="carousel-item carousel-item-bg" style="background-image: url('https://picsum.photos/1920/1080?random=1');"></div>
                    </div>

                <button class="carousel-control-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Sebelumnya</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Berikutnya</span>
                </button>
            </div>
            <div class="slider-overlay"></div>
        </div>
    </div>

    <div class="main-content d-flex flex-column h-100 text-white">
        <div class="container-fluid flex-grow-1 d-flex align-items-center justify-content-center">
            <div class="row w-100">
                <div class="col-md-3 d-none d-md-block"></div>
                
                <div class="col-md-9 d-flex flex-column h-100 text-center">
                    <nav class="navbar navbar-expand-lg navbar-dark bg-transparent navbar-custom mt-3">
                        <div class="container-fluid">
                            <ul class="navbar-nav mx-auto mb-2 mb-lg-0">
                                <li class="nav-item mx-2"><a class="nav-link active" href="#">Beranda</a></li>
                                <li class="nav-item mx-2"><a class="nav-link" href="#">Layanan</a></li>
                                <li class="nav-item mx-2"><a class="navbar-brand d-lg-block d-none" href="#"><img src="https://placehold.co/150x50/white/white" alt="Logo" style="filter: brightness(0) invert(1);"></a></li>
                                <li class="nav-item mx-2"><a class="nav-link" href="#">Tentang</a></li>
                                <li class="nav-item mx-2"><a class="nav-link" href="#">Kontak</a></li>
                            </ul>
                        </div>
                    </nav>

                    <div class="flex-grow-1 d-flex flex-column justify-content-center align-items-center">
                        <h1 class="display-3 fw-bold mb-3">Selamat Datang</h1>
                        <p class="lead mb-4">
                            Nikmati pengalaman visual yang tak terlupakan.
                        </p>
                        <a href="#" class="btn btn-primary btn-lg btn-custom me-2 mb-2">Mulai Sekarang</a>
                        <a href="#" class="btn btn-outline-light btn-lg btn-custom">Pelajari Lebih Lanjut</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const myCarousel = document.getElementById('heroCarousel');
            const videos = myCarousel.querySelectorAll('video');

            myCarousel.addEventListener('slid.bs.carousel', function () {
                videos.forEach(video => { video.pause(); });
                const activeItem = myCarousel.querySelector('.carousel-item.active');
                const activeVideo = activeItem.querySelector('video');
                if (activeVideo) { activeVideo.play(); }
            });
            
            const firstVideo = myCarousel.querySelector('.carousel-item.active video');
            if(firstVideo) { firstVideo.play(); }
        });
    </script>
</body>
</html>