function fetchData() {
    fetch('http://localhost/landing/data.php')
        .then(response => {
            if (!response.ok) {
                throw new Error('Jaringan bermasalah atau respons server tidak OK');
            }
            return response.json();
        })
        .then(data => {
            if (data.error) {
                throw new Error(data.error);
            }

            // 💡 Strategi Double Buffering:
            // 1. Buat kontainer sementara (virtual) di memori
            const newContainer = document.createElement('div');
            newContainer.classList.add('col'); // Pastikan kelas grid tetap ada

            // 2. Loop data dan tambahkan card ke kontainer sementara
            data.forEach(item => {
                const colDiv = document.createElement('div');
                colDiv.classList.add('col');
    //======================case untuk alarm level START=====================//
                //console.log(item.alarm_level);
                const Alarm = item.alarm_level.split(",");
                console.log(Alarm[0]);
    //======================case untuk alarm level END=====================//            
                if (item.alat > 8000) {
                    colDiv.innerHTML = `
                        
                        <!-- SENSOR ITEM 1: ARL - Red Alert (Level Max) -->
                        <div class="sensor-item">
                            <div class="sensor-header">
                                <h5 class="sensor-title"><i class="sensor-icon bi bi-geo-alt-fill"></i> ${item.location}</h5>
                                <div class="d-flex align-items-center">
                                    <span class="sensor-badge awl">AWLR | ${item.alat}</span>
                                </div>
                            </div>
                            <p class="sensor-info m-0">
                                <i class="bi bi-calendar"></i> ${item.last_sending}
                            </p>
                            <div class="sensor-value-container">
                                <div class="level-indicator">
                                    <div class="level-indicator-bar">
                                        <div class="level-indicator-segments">
                                            <div class="level-segment segment-green" style="width: 20%;"></div>
                                            <div class="level-segment segment-yellow" style="width: 30%;"></div>
                                            <div class="level-segment segment-orange" style="width: 30%;"></div>
                                            <div class="level-segment segment-red" style="width: 20%;"></div>
                                        </div>
                                        <!-- Marker ditempatkan pada posisi 100% -->
                                        <div class="current-level-mark" style="left: 100%;"></div> 
                                    </div>
                                    <div class="level-labels">
                                        <span>0</span>
                                        <span>50</span>
                                        <span>100</span>
                                        <span>200</span>
                                        
                                    </div>
                                </div>
                                <!-- Nilai yang ditampilkan -->
                                <div class="sensor-value alert-red">${item.value_actual} ${item.unit}</div> 
                            </div>
                        </div>
                    `;
                } else {
                    colDiv.innerHTML = `
                        <!-- SENSOR ITEM 1: ARL - Red Alert (Level Max) -->
                        <div class="sensor-item">
                            <div class="sensor-header">
                                <h5 class="sensor-title"><i class="sensor-icon bi bi-geo-alt-fill"></i> ${item.location}</h5>
                                <div class="d-flex align-items-center">
                                    <span class="sensor-badge arl">ARL | ${item.alat}</span>
                                </div>
                            </div>
                            <p class="sensor-info m-0">
                                <i class="bi bi-calendar"></i> ${item.last_sending}
                            </p>
                            <div class="sensor-value-container">
                                <div class="level-indicator">
                                    <div class="level-indicator-bar">
                                        <div class="level-indicator-segments">
                                            <div class="level-segment segment-green" style="width: 20%;"></div>
                                            <div class="level-segment segment-yellow" style="width: 30%;"></div>
                                            <div class="level-segment segment-orange" style="width: 30%;"></div>
                                            <div class="level-segment segment-red" style="width: 20%;"></div>
                                        </div>
                                        <!-- Marker ditempatkan pada posisi 100% -->
                                        <div class="current-level-mark" style="left: 95%;"></div> 
                                    </div>
                                    <div class="level-labels">
                                        <span>0</span>
                                        <span>50</span>
                                        <span>100</span>
                                        <span>200</span>
                                       
                                    </div>
                                </div>
                                <!-- Nilai yang ditampilkan -->
                                <div class="sensor-value alert-blue">${item.value_actual} ${item.unit}</div> 
                            </div>
                        </div>
                    `;
                    /*
                    <div class="card h-100 mt-2">
                            <div class="card-body">
                                <h5 class="card-title">${item.location}</h5>
                                <h6 class="card-subtitle mb-2 text-muted">Alat: ${item.alat} - ARL</h6>
                                <p class="card-text">
                                    <strong>Nilai:</strong> ${item.value_actual} ${item.unit} <br>
                                    <strong>Lokasi:</strong> ${item.desa}, ${item.kecamatan} <br>
                                    <strong>Kabupaten:</strong> ${item.kabupaten} <br>
                                    <strong>Provinsi:</strong> ${item.provinsi} <br>
                                    <strong>Alarm Level:</strong> ${Alarm} <br>
                                    <small class="text-muted">Terakhir Kirim: ${item.last_sending}</small>
                                </p>
                            </div>
                        </div>
                    */
                }
                newContainer.appendChild(colDiv);
            });

            // 3. Ganti konten lama dengan konten baru secara bersamaan
            const dataContainer = document.getElementById('dataContent');
            dataContainer.innerHTML = '';
            dataContainer.appendChild(newContainer);
        })
        .catch(error => {
            console.error('Ada masalah dengan operasi fetch:', error);
            const dataContainer = document.getElementById('dataContent');
            dataContainer.innerHTML = '<p style="color: red;">Gagal memuat data. Periksa koneksi atau URL API.</p>';
        });
}

// Panggil fungsi fetchData() setiap 10 detik
setInterval(fetchData, 120000);

// Panggil pertama kali saat halaman dimuat
fetchData();