<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Sensor Real-time</title>
    <style>
        body {
            font-family: sans-serif;
            text-align: center;
            margin-top: 50px;
            background-color: #f0f2f5;
            color: #333;
        }

        .data-container {
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            padding: 30px;
            display: inline-block;
            min-width: 450px;
            text-align: left;
        }

        h1 {
            color: #2c3e50;
        }

        h2 {
            margin-top: 0;
            color: #34495e;
            text-align: center;
        }

        p {
            font-size: 1.1em;
            line-height: 1.6;
        }

        .label {
            font-weight: bold;
            color: #555;
            display: inline-block;
            width: 120px;
        }

        .data-value {
            font-weight: bold;
            color: #3498db;
        }
    </style>
</head>

<body>

    <h1>Informasi Sensor Tatonas</h1>
    <div class="data-container">
        <h2>Detail Lokasi & Sensor</h2>
        <p><span class="label">Lokasi:</span> <span class="data-value" id="location">...</span></p>
        <p><span class="label">Desa:</span> <span class="data-value" id="desa">...</span></p>
        <p><span class="label">Kecamatan:</span> <span class="data-value" id="kecamatan">...</span></p>
        <p><span class="label">Kabupaten:</span> <span class="data-value" id="kabupaten">...</span></p>
        <p><span class="label">Provinsi:</span> <span class="data-value" id="provinsi">...</span></p>
        <p><span class="label">Latitude:</span> <span class="data-value" id="latitude">...</span></p>
        <p><span class="label">Longitude:</span> <span class="data-value" id="longitude">...</span></p>
        <p><span class="label">Terakhir Kirim:</span> <span class="data-value" id="last_sending">...</span></p>
        <p><span class="label">Nilai Aktual:</span> <span class="data-value" id="value_actual">...</span></p>
        <p><span class="label">Unit:</span> <span class="data-value" id="unit">...</span></p>
        <p><span class="label">Tingkat Alarm:</span> <span class="data-value" id="alarm_level">...</span></p>
    </div>

    <script>
        // Fungsi untuk mengambil data dari skrip PHP
        function fetchData() {
            fetch('get_api_data.php')
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Jaringan bermasalah atau respons server tidak OK');
                    }
                    return response.json();
                })
                .then(data => {
                    // Cek apakah ada error dari PHP
                    if (data.error) {
                        throw new Error(data.error);
                    }

                    // Memperbarui elemen HTML dengan data yang diterima
                    document.getElementById('location').innerText = data.location;
                    document.getElementById('desa').innerText = data.desa;
                    document.getElementById('kecamatan').innerText = data.kecamatan;
                    document.getElementById('kabupaten').innerText = data.kabupaten;
                    document.getElementById('provinsi').innerText = data.provinsi;
                    document.getElementById('latitude').innerText = data.latitude;
                    document.getElementById('longitude').innerText = data.longitude;
                    document.getElementById('last_sending').innerText = data.last_sending;
                    document.getElementById('value_actual').innerText = data.value_actual;
                    document.getElementById('unit').innerText = data.unit;
                    document.getElementById('alarm_level').innerText = data.alarm_level;
                })
                .catch(error => {
                    console.error('Ada masalah dengan operasi fetch:', error);
                    document.querySelector('.data-container').innerHTML = '<p style="color: red;">Gagal memuat data. Periksa koneksi atau URL API.</p>';
                });
        }

        // Panggil fungsi fetchData() pertama kali saat halaman dimuat
        fetchData();

        // Atur interval untuk memanggil fungsi setiap 20 detik
        setInterval(fetchData, 20000);
    </script>
</body>

</html>