document.addEventListener('DOMContentLoaded', () => {
    const hardwareCodes = ['3776', '3952', '3984', '8485', '8484', '8590', '8603'];
    const dataContainer = document.getElementById('data-container');
    const baseUrl = 'https://tatonas.co.id/api/v2/realtime?uc=QSAygEUI_dinas_puprpkpp_provinsi_riau&pc=059&hw=';

    const fetchData = async (code) => {
        const url = `${baseUrl}${code}`;
        try {
            const response = await fetch(url);
            if (!response.ok) {
                throw new Error(`HTTP error! Status: ${response.status}`);
            }
            const data = await response.json();
            return { code, data };
        } catch (error) {
            console.error(`Gagal mengambil data untuk kode ${code}:`, error);
            return { code, error: `Gagal mengambil data.` };
        }
    };

    const displayData = async () => {
        dataContainer.innerHTML = '<p>Memuat data...</p>';
        const promises = hardwareCodes.map(fetchData);
        const results = await Promise.all(promises);

        dataContainer.innerHTML = '';
        results.forEach(result => {
            const itemDiv = document.createElement('div');
            itemDiv.className = 'data-item';

            const title = document.createElement('h3');
            title.textContent = `Kode Hardware: ${result.code}`;
            itemDiv.appendChild(title);

            const pre = document.createElement('pre');
            if (result.error) {
                pre.textContent = result.error;
                pre.style.color = 'red';
            } else {
                pre.textContent = JSON.stringify(result.data, null, 2);
            }
            itemDiv.appendChild(pre);

            dataContainer.appendChild(itemDiv);
        });
    };

    displayData();
});