<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Sensor Real-time</title>
    <style>
        body {
            font-family: sans-serif;
            text-align: center;
            margin-top: 50px;
            background-color: #f0f2f5;
            color: #333;
        }

        .data-container {
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            padding: 30px;
            display: inline-block;
            min-width: 450px;
            text-align: left;
        }

        h1 {
            color: #2c3e50;
        }

        h2 {
            margin-top: 0;
            color: #34495e;
            text-align: center;
        }

        p {
            font-size: 1.1em;
            line-height: 1.6;
        }

        .label {
            font-weight: bold;
            color: #555;
            display: inline-block;
            width: 120px;
        }

        .data-value {
            font-weight: bold;
            color: #3498db;
        }
    </style>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>

    <h1>Informasi Sensor Tatonas</h1>
    <div class="data-container" id="dataContent"></div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Fungsi untuk mengambil data dari skrip PHP
        //const json 
        function fetchData() {
            fetch('http://localhost/landing/tes/fetch_data.php')
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Jaringan bermasalah atau respons server tidak OK');
                    }
                    return response.json();
                })
                .then(data => {
                    // Cek apakah ada error dari PHP
                    if (data.error) {
                        throw new Error(data.error);
                    }

                    // Memperbarui elemen HTML dengan data yang diterima
                    //document.getElementById('dataContent').innerText = 'xx';
                    //console.log(data[1].desa);
                    //loop data json
                    // Loop melalui setiap item dalam array dan buat card
                    const dataContainer = document.getElementById('dataContent');

                    data.forEach(item => {
                        // Buat elemen div untuk kolom grid
                        const colDiv = document.createElement('div');
                        colDiv.classList.add('col');

                        if(item.alat > 8000){
                        // Buat elemen card dan isinya
                        colDiv.innerHTML = `
                            <div class="card h-100 mt-2">
                                <div class="card-body">
                                    <h5 class="card-title">${item.location}</h5>
                                    <h6 class="card-subtitle mb-2 text-muted">Alat: ${item.alat} - AWRL</h6>
                                    <p class="card-text">
                                        <strong>Nilai Aktual:</strong> ${item.value_actual} ${item.unit} <br>
                                        <strong>Lokasi:</strong> ${item.desa}, ${item.kecamatan} <br>
                                        <strong>Kabupaten:</strong> ${item.kabupaten} <br>
                                        <strong>Provinsi:</strong> ${item.provinsi} <br>
                                        <small class="text-muted">Terakhir Kirim: ${item.last_sending}</small>
                                    </p>
                                </div>
                            </div>
                        `;
                        }else{
                            // Buat elemen card dan isinya
                            colDiv.innerHTML = `
                                <div class="card h-100 mt-2">
                                    <div class="card-body">
                                        <h5 class="card-title">${item.location}</h5>
                                        <h6 class="card-subtitle mb-2 text-muted">Alat: ${item.alat} - ARL</h6>
                                        <p class="card-text">
                                            <strong>Nilai Aktual:</strong> ${item.value_actual} ${item.unit} <br>
                                            <strong>Lokasi:</strong> ${item.desa}, ${item.kecamatan} <br>
                                            <strong>Kabupaten:</strong> ${item.kabupaten} <br>
                                            <strong>Provinsi:</strong> ${item.provinsi} <br>
                                            <small class="text-muted">Terakhir Kirim: ${item.last_sending}</small>
                                        </p>
                                    </div>
                                </div>
                            `;
                        }
                        // Tambahkan card ke container
                        dataContainer.appendChild(colDiv);
                    });
                    
                })
                .catch(error => {
                    console.error('Ada masalah dengan operasi fetch:', error);
                    document.querySelector('.data-container').innerHTML = '<p style="color: red;">Gagal memuat data. Periksa koneksi atau URL API.</p>';
                });
        }

        // Panggil fungsi fetchData() pertama kali saat halaman dimuat
        fetchData();

        // Atur interval untuk memanggil fungsi setiap 20 detik
        //setInterval(fetchData, 20000);
    </script>
</body>

</html>