<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        // Load helper URL jika belum di autoload
        $this->load->helper('url');
    }

    public function index()
    {
       
        // Data yang akan dikirim ke template
        $data['title'] = "Dashboard Saya"; // Untuk title di <head>
        $data['pageTitle'] = "Dashboard"; // Untuk title di navbar
        $data['content'] = 'dashboard/dashboard_view'; // Nama file view yang akan dimuat di content
        //defenisikan file js
        $data['js_files'] = ['dashboard/dashboard.js'];
        $data['css_files'] = ['css/sensor.css'];
        // TAMBAHKAN BARIS INI UNTUK MENGUBAH TEKS BERJALAN
        //$data['running_text'] = 'Pengumuman: Sistem akan melakukan maintenance pada hari Sabtu pukul 22:00 WIB. Mohon maaf atas ketidaknyamanannya.';


        // Memuat template dan menyertakan data
        $this->load->view('templates/layout', $data);
    }

    public function fetchMultipleAPIData($hardware_codes)
    {
        $base_url = "https://tatonas.co.id/api/v2/realtime?uc=QSAygEUI_dinas_puprpkpp_provinsi_riau&pc=059&hw=";

        $multiHandle = curl_multi_init();
        $handles = [];
        $results = [];

        // Inisialisasi cURL handles untuk setiap hardware code
        foreach ($hardware_codes as $hw_code) {
            $url = $base_url . $hw_code;
            $handles[$hw_code] = curl_init();

            curl_setopt_array($handles[$hw_code], [
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json',
                    'Accept: application/json',
                    'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'
                ]
            ]);

            curl_multi_add_handle($multiHandle, $handles[$hw_code]);
        }

        // Eksekusi multiple requests secara parallel
        $running = null;
        do {
            curl_multi_exec($multiHandle, $running);
            curl_multi_select($multiHandle);
        } while ($running > 0);

        // Ambil hasil dari setiap request
        foreach ($handles as $hw_code => $handle) {
            $response = curl_multi_getcontent($handle);
            $httpCode = curl_getinfo($handle, CURLINFO_HTTP_CODE);
            $error = curl_error($handle);

            $results[$hw_code] = [
                'success' => !$error && $httpCode === 200,
                'http_code' => $httpCode,
                'error' => $error,
                'data' => json_decode($response, true),
                'raw_response' => $response
            ];

            curl_multi_remove_handle($multiHandle, $handle);
            curl_close($handle);
        }

        curl_multi_close($multiHandle);
        return $results;
    }

    public function viewJson()
    {
        $hardware_codes = ['3776', '3952', '3984', '8485', '8484', '8590', '8603'];
        // Panggil function untuk mengambil data
        $results = $this->fetchMultipleAPIData($hardware_codes);

        // Format ulang data sesuai kebutuhan
        $formatted_data = [];

        foreach ($results as $hw_code => $result) {
            if ($result['success'] && isset($result['data']['data'])) {
                $data = $result['data']['data'];

                // Ambil data sensor (ambil sensor pertama yang ada)
                $sensor_data = reset($data['sensor']); // Mengambil elemen pertama dari array sensor

                $formatted_data[] = [
                    'alat' => $data['hardware_code'],
                    'location' => $data['location'],
                    'desa' => $data['desa'],
                    'kecamatan' => $data['kecamatan'],
                    'kabupaten' => $data['kabupaten'],
                    'provinsi' => $data['provinsi'],
                    'latitude' => (float)$data['latitude'],
                    'longitude' => (float)$data['longitude'],
                    'last_sending' => $data['last_sending'],
                    'sensor' => $data['sensor'],
                    'value_actual' => $sensor_data['value_actual'],
                    'unit' => $sensor_data['unit'],
                    'alarm_level' => $sensor_data['alarm_level']
                ];
            }
        }

        // Output sebagai JSON
        header('Content-Type: application/json');
        echo json_encode($formatted_data, JSON_PRETTY_PRINT);
    }

    public function dataJson()
    {
        $hardware_codes = ['3776', '3952', '3984', '8485', '8484', '8590', '8603'];
        // Panggil function untuk mengambil data
        $results = $this->fetchMultipleAPIData($hardware_codes);

        // Format ulang data sesuai kebutuhan
        $formatted_data = [];

        foreach ($results as $hw_code => $result) {
            if ($result['success'] && isset($result['data']['data'])) {
                $data = $result['data']['data'];

                // Ambil data sensor (ambil sensor pertama yang ada)
                $sensor_data = reset($data['sensor']); // Mengambil elemen pertama dari array sensor

                $formatted_data[] = [
                    'alat' => $data['hardware_code'],
                    'location' => $data['location'],
                    'desa' => $data['desa'],
                    'kecamatan' => $data['kecamatan'],
                    'kabupaten' => $data['kabupaten'],
                    'provinsi' => $data['provinsi'],
                    'latitude' => (float)$data['latitude'],
                    'longitude' => (float)$data['longitude'],
                    'last_sending' => $data['last_sending'],
                    'sensor' => $data['sensor'],
                    'value_actual' => $sensor_data['value_actual'],
                    'unit' => $sensor_data['unit'],
                    'alarm_level' => $sensor_data['alarm_level']
                ];
            }
        }

        // Output sebagai JSON
        
    }
}
