<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Hello extends CI_Controller {


    public function __construct()
    {
        parent::__construct();
        // Memuat helper URL untuk mempermudah penggunaan URL dasar (base_url()) jika diperlukan.
        $this->load->helper('url');
    }

    public function debug($var)
    {
        echo "<pre>";
        print_r($var);
        echo "</pre>";
    }

	public function index()
	{
		// 1. Definisikan URL API yang akan dipanggil
        $url = 'https://tatonas.co.id/api/v2/realtime?uc=QSAygEUI_dinas_puprpkpp_provinsi_riau&pc=059&hw=8484';

        // 2. Inisialisasi cURL
        $ch = curl_init();

        // 3. Set Opsi cURL
        // Set URL target
        curl_setopt($ch, CURLOPT_URL, $url);
        
        // Atur agar hasil transfer dikembalikan sebagai string, bukan langsung ditampilkan
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
        
        // Opsional: Atur User Agent (terkadang API memerlukan ini)
        curl_setopt($ch, CURLOPT_USERAGENT, 'CodeIgniter-App');

        // Opsional: Jika API menggunakan HTTPS (seperti ini)
        // Jika Anda menemukan error SSL, coba tambahkan baris di bawah, tetapi hati-hati dalam produksi:
        // curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);


        // 4. Eksekusi cURL dan simpan hasilnya
        $response = curl_exec($ch);

        // 5. Cek jika ada error cURL
        if (curl_errno($ch)) {
            // Tampilkan pesan error jika terjadi
            echo 'cURL Error: ' . curl_error($ch);
            curl_close($ch);
            return;
        }

        // 6. Tutup cURL
        curl_close($ch);

        // 7. Dekode JSON menjadi array PHP
        // Parameter 'true' di json_decode() mengubah hasilnya menjadi array asosiatif
        $data_array = json_decode($response, true);
        // 8. rapikan data 
        $main_data = $data_array['data'];
        $sensor = $main_data['sensor'];
        $value = $sensor['Tinggi Muka Air'];

        $this->debug($main_data);
        echo "<hr/>";

        
	}
}
