function fetchData() {
    fetch('dashboard/viewJson')
        .then(response => {
            if (!response.ok) {
                throw new Error('Jaringan bermasalah atau respons server tidak OK');
            }
            return response.json();
        })
        .then(data => {
            if (data.error) {
                throw new Error(data.error);
            }

            // ðŸ’¡ Strategi Double Buffering:
            // 1. Buat kontainer sementara (virtual) di memori
            const newContainer = document.createElement('div');
            newContainer.classList.add('row'); // Pastikan kelas grid tetap ada

            // 2. Loop data dan tambahkan card ke kontainer sementara
            data.forEach(item => {
                const colDiv = document.createElement('div');
                colDiv.classList.add('col-12');
    //======================case untuk alarm level START=====================//
                //console.log(item.alarm_level);
                const Alarm = item.alarm_level.split(",");
                //console.log(Alarm[0]);
    //======================case untuk alarm level END=====================// 
               
                if (item.alat > 8000) {

                    //====================== case Level Ketinggian =====================//
                        //console.log(item.alarm_level);
                        let segmen_level_air = '';
                        if(item.value_actual > 0 && item.value_actual <= Alarm[1]){
                            segmen_level_air = `<span class="d-flex justify-content-center align-items-center tag badge bg-info" style="font-size:15px">${item.value_actual} ${item.unit}</span>`;
                        }else if(item.value_actual > Alarm[1] && item.value_actual <= Alarm[2]){
                            segmen_level_air = `<span class="d-flex justify-content-center align-items-center tag badge bg-success" style="font-size:15px">${item.value_actual} ${item.unit}</span>`;
                        }else if(item.value_actual > Alarm[2] && item.value_actual <= Alarm[3]){
                            segmen_level_air = `<span class="d-flex justify-content-center align-items-center tag badge bg-primary" style="font-size:15px">${item.value_actual} ${item.unit}</span>`;
                        }else if(item.value_actual > Alarm[3] && item.value_actual <= Alarm[4]){
                            segmen_level_air = `<span class="d-flex justify-content-center align-items-center tag badge bg-warning" style="font-size:15px">${item.value_actual} ${item.unit}</span>`;
                        }else{
                            segmen_level_air = `<span class="d-flex justify-content-center align-items-center tag badge bg-danger" style="font-size:15px">${item.value_actual} ${item.unit}</span>`;
                        }      
                    //====================== case Level Ketinggian END=====================//

                    colDiv.innerHTML = `
                                
                                    <div class="col-md-12 pl-1 pb-0">
                                        <div class="card mt-1 mb-1">
                                            <div class="card-header pt-1 pb-1">
                                                <div class="row">
                                                    <div class="col-md-8 pr-1">
                                                        <h7 class="mb-0 pb-10"><strong>${item.location} | ${item.kabupaten}</strong></h7> 
                                                        <br>
                                                        <span class="flex-align-center" style="font-size : .800rem"><span class="badge bg-success">AWRL | ${item.alat}</span> <i class="material-icons" style="font-size: inherit; vertical-align: middle;">calendar_month</i> ${item.last_sending}</span>
                                                    </div>
                                                    
                                                    <div class="col-md-4 ml-auto d-flex justify-content-end">
                                                        ${segmen_level_air}
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body pt-1 pb-1">
                                                <div class="progress progress-line-danger mb-0">
                                                    <div class="progress-bar progress-bar-info" style="width: 20%">
                                                        <span class="sr-only">20% </span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-success" style="width: 20%">
                                                        <span class="sr-only">20% </span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-primary" style="width: 20%">
                                                        <span class="sr-only">20% </span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-warning" style="width: 20%">
                                                        <span class="sr-only">20% </span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-danger" style="width: 20%">
                                                        <span class="sr-only">20% </span>
                                                    </div>
                                                </div>
                                                <div class="row pl-3">
                                                    <div style="width: 20% ;font-size : .700rem"><span>${Alarm[0]}</span></div>
                                                    <div style="width: 20% ;font-size : .700rem"><span>${Alarm[1]}</span></div>
                                                    <div style="width: 20% ;font-size : .700rem"><span>${Alarm[2]}</span></div>
                                                    <div style="width: 19%;font-size : .700rem"><span>${Alarm[3]}</span></div>
                                                    <div style="width: 20% ;font-size : .700rem"><span>${Alarm[4]}</span></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                               
                    `;
                } else {

                    //======================Level Ketinggian=====================//
                        //console.log(item.alarm_level);
                        let segmen_level_hujan = '';
                        if(item.value_actual <= Alarm[1]){
                            segmen_level_hujan = `<span class="d-flex justify-content-center align-items-center tag badge bg-info" style="font-size:15px">${item.value_actual} ${item.unit}</span>`;
                        }else{
                            segmen_level_hujan = `<span class="d-flex justify-content-center align-items-center tag badge bg-danger" style="font-size:15px">${item.value_actual} ${item.unit}</span>`;
                        }      
                    //======================case untuk alarm level END=====================//

                    colDiv.innerHTML = `
                                
                                    <div class="col-md-12 pl-1">
                                        <div class="card mt-1 mb-1">
                                            <div class="card-header pt-1 pb-1">
                                                <div class="row">
                                                    <div class="col-md-8 pr-1">
                                                        <h7 class="mb-0 pb-10"><strong>${item.location} | ${item.kabupaten}</strong></h7> 
                                                        <br>
                                                        <span class="flex-align-center" style="font-size : .800rem"><span class="badge bg-info">ARL | ${item.alat}</span> <i class="material-icons" style="font-size: inherit; vertical-align: middle;">calendar_month</i> ${item.last_sending}</span>
                                                    </div>
                                                    
                                                    <div class="col-md-4 ml-auto d-flex justify-content-end">
                                                        ${segmen_level_hujan}
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body pt-1 pb-1">
                                                <div class="progress progress-line-danger mb-0">
                                                    <div class="progress-bar progress-bar-info" style="width: 20%">
                                                        <span class="sr-only">20% </span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-danger" style="width: 80%">
                                                        <span class="sr-only">20% </span>
                                                    </div>
                                                </div>
                                                <div class="row pl-3">
                                                    <div style="width: 20% ;font-size : .700rem"><span>0</span></div>
                                                    <div style="width: 80% ;font-size : .700rem"><span>100</span></div>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                
                    `;
                    /*
                    <div class="card h-100 mt-2">
                            <div class="card-body">
                                <h5 class="card-title">${item.location}</h5>
                                <h6 class="card-subtitle mb-2 text-muted">Alat: ${item.alat} - ARL</h6>
                                <p class="card-text">
                                    <strong>Nilai:</strong> ${item.value_actual} ${item.unit} <br>
                                    <strong>Lokasi:</strong> ${item.desa}, ${item.kecamatan} <br>
                                    <strong>Kabupaten:</strong> ${item.kabupaten} <br>
                                    <strong>Provinsi:</strong> ${item.provinsi} <br>
                                    <strong>Alarm Level:</strong> ${Alarm} <br>
                                    <small class="text-muted">Terakhir Kirim: ${item.last_sending}</small>
                                </p>
                            </div>
                        </div>
                    */
                }
                newContainer.appendChild(colDiv);

                //console.log(item);
            });

            // 3. Ganti konten lama dengan konten baru secara bersamaan
            const dataContainer = document.getElementById('dataContent');
            dataContainer.innerHTML = '';
            dataContainer.appendChild(newContainer);

            // UNTUK RUNNING TEXT
            let Running_Text = '';
            data.forEach(item => {
                //console.log(item);
                Running_Text += `Lokasi ${item.location} ketinggian air nya adalah ${item.value_actual} ${item.unit} | `;
            });

            //
            Running_Text = Running_Text.slice(0,-3);
            // Gandakan teks untuk membuat loop yang mulus
            const finalText = Running_Text + ' &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ' + Running_Text;
            // Perbarui HTML running text
            document.getElementById('running-text-content').innerHTML = finalText;

        })
        .catch(error => {
            console.error('Ada masalah dengan operasi fetch:', error);
            const dataContainer = document.getElementById('dataContent');
            dataContainer.innerHTML = '<p style="color: red;">Gagal memuat data. Periksa koneksi atau URL API.</p>';
        });

        
}

// Panggil fungsi fetchData() setiap 10 detik
setInterval(fetchData, 60000);

// Panggil pertama kali saat halaman dimuat
fetchData();

// running text 


    $(document).ready(function() {
        $('#mediaSlider').on('slid.bs.carousel', function () {
            // Ambil semua iframe di dalam carousel
            let iframes = $(this).find('iframe');
            
            // Loop melalui setiap iframe dan hentikan videonya
            iframes.each(function() {
                // Kirim perintah 'pauseVideo' ke iframe YouTube
                $(this)[0].contentWindow.postMessage('{"event":"command","func":"pauseVideo","args":""}', '*');
            });
        });
    });
